// LAB:09  Design the following FIR filters with the given specification.
//            

////////////////////////////////////////////////////////////////////////
//    Example:
//                 filter type ('lp','hp','sb','bp')
//                 Filter order (pos integer)(odd for ftype='hp' or 'sb')
//                 cfreq=2-vector of cutoff frequencies (0<cfreq(1),cfreq(2)<.5) only cfreq(1) is used when ftype='lp' or 'hp'
//                 wtype= Window type ('re','tr','hm','hn','kr','ch')
//                 fpar=2-vector of window parameters. Kaiser window fpar(1)>0 fpar(2)=0. Chebyshev window fpar(1)>0, fpar(2)<0 or fpar(1)<0, 0<fpar(2)<.5
//                 wft=time domain filter coefficients
//                 wfm=frequency domain filter response on the grid fr
//                 fr=Frequency grid
///////////////////////////////////////////////////////////////////////////

//Evaluate magnitude response of the filter

// Version : Scilab 5.4.1
// Operating System : Window-xp, Window-7

clc;
close;
clear;

ftype='bp';
forder=33;
fs=8000;
cfreq=[(450/fs) (500/fs)];
wtype='kr';
fpar=[0.8 0];


[wft1,wfm1,fr1]=wfir(ftype,forder,cfreq,'re',fpar);
[wft2,wfm2,fr2]=wfir(ftype,forder,cfreq,'hm',fpar);
[wft3,wfm3,fr3]=wfir(ftype,forder,cfreq,'hn',fpar);
[wft4,wfm4,fr4]=wfir(ftype,forder,cfreq,'kr',fpar);
[wft5,wfm5,fr5]=wfir(ftype,forder,cfreq,'tr',fpar);
//[wft6,wfm6,fr6]=wfir(ftype,forder,cfreq,'ch',fpar);

clf();
plot(fr1,wfm1,fr2,wfm2,fr3,wfm3,fr4,wfm4,fr5,wfm5);
legend('rectangal Window','Hamming Window','Hanning Window','Kaiser Window','Triagle Window');
title('Frequency Responce','color','red','fontsize', 4);
xlabel("Frequency", "fontsize", 2,"color", "blue");
ylabel("Magnitude", "fontsize", 2, "color", "blue");


